m = 4 # number of resources
D = 1 # inflow and outflow rate
n_tot = 20 # number of species in species pool
# set parameters for each species randomly
h_all = matrix(runif(n_tot*m)*0.1,n_tot,m)
r_all = matrix(D*(1.1+runif(n_tot*m)),n_tot,m)
Q_all = matrix(0.001,n_tot,m)

# choose (at random) the limiting resource for each species
js_limiting = sample(m,n_tot,replace=T)
# h values for limiting resources
h_all[cbind(1:n_tot,js_limiting)] = 1
# Q values for limiting resources
Q_all[cbind(1:n_tot,js_limiting)] = 0.2

# sample from the species pool a set of species for our
# initial community
n = 10 # number of species to sample
iii = sample(n_tot,n)
h = matrix(h_all[iii,],n,m)
r = matrix(r_all[iii,],n,m)
Q = matrix(Q_all[iii,],n,m)

S_j = 10 # input concentration for each resource
S = rep(S_j,m) # input resource concentrations
X0 = c(runif(n)*S_j,S) # initial conditions
parms = list(r=r,h=h,Q=Q,S=S,D=D) # parameters for ode()
ts=seq(0,10000,length.out=10000) # timesteps for ode()
# run ode() to get time series
X_t = ode(X0,ts,Monod_derivatives,parms=parms)

# calculate variables of interest from output
N_final = X_t[length(ts),1+(1:n)] # final abundances
n_final = sum(N_final>0.01) # final number of species
B_final = sum(N_final*rowSums(Q)) # final total biomass 
